IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Get_Missing_Admission_Iens]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Get_Missing_Admission_Iens]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author		:	PII
-- Created date	:	07/01/2013
-- Description	:	Gets admission iens that does not exists in BMS.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Get_Missing_Admission_Iens] 
	@ADMISSION_IEN_LIST VARCHAR(MAX),
	@VISTA_SITE_UID UNIQUEIDENTIFIER
AS
BEGIN
	SET NOCOUNT ON;

	SELECT S.VALUE as ADMISSION_IEN
	FROM dbo.fn_Split_String(@ADMISSION_IEN_LIST, ',') AS S
		LEFT JOIN ADMISSION_EVN AS AE ON AE.IEN = S.VALUE AND AE.VISTA_SITE_UID = @VISTA_SITE_UID
	WHERE AE.IEN is NULL
	
END
GO